//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module ERROR.CPP
//
//-----------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////
// Includes
//
////////////////////////////////////////////////////////////////////////
#include "Common.h"
#include "Error.h"
#include "Property.h"
#include "DataSource.h"	//IID_IAggregate
#include <olectl.h>		//IConnectionPoints interface


////////////////////////////////////////////////////////////////////////
// Globals
//
////////////////////////////////////////////////////////////////////////
DWORD g_dwErrorPost = EP_ERRORINFO_FAILURE | EP_HRESULT_NOERRORINFO;
BOOL SetErrorPosting(ERRORPOST eErrorPost, BOOL fSet)
{ 
	if(fSet)
		g_dwErrorPost |= eErrorPost;
	else
		g_dwErrorPost &= ~eErrorPost;

	return TRUE;
};

BOOL GetErrorPosting(ERRORPOST eErrorPost) 
{ 
	return g_dwErrorPost & eErrorPost;
};


/////////////////////////////////////////////////////////////////////////////
// 	Interface Map
//
/////////////////////////////////////////////////////////////////////////////
const static GUIDMAP g_rgInterfaceMap[] =
{
	//TEnumerator
		& VALUE_CHAR(IID_IParseDisplayName),
		& VALUE_CHAR(IID_ISourcesRowset),

	//TDataSource
		& VALUE_CHAR(IID_IDBInitialize),
		& VALUE_CHAR(IID_IDBProperties),
		& VALUE_CHAR(IID_IDBCreateSession),
		& VALUE_CHAR(IID_IDBInfo),
		& VALUE_CHAR(IID_IPersist),
		& VALUE_CHAR(IID_IDBAsynchStatus),
		& VALUE_CHAR(IID_IDBDataSourceAdmin),
		& VALUE_CHAR(IID_IPersistFile),
		& VALUE_CHAR(IID_ISupportErrorInfo),

	//TSession
		& VALUE_CHAR(IID_IGetDataSource),
		& VALUE_CHAR(IID_IOpenRowset),
		& VALUE_CHAR(IID_ISessionProperties),
		& VALUE_CHAR(IID_IDBCreateCommand),
		& VALUE_CHAR(IID_IDBSchemaRowset),
		& VALUE_CHAR(IID_IIndexDefinition),
		& VALUE_CHAR(IID_ITableDefinition),
		& VALUE_CHAR(IID_ITransactionJoin),
		& VALUE_CHAR(IID_ITransactionLocal),
		& VALUE_CHAR(IID_ITransactionObject),

	//TCommand
		& VALUE_CHAR(IID_IAccessor),
		& VALUE_CHAR(IID_IColumnsInfo),
		& VALUE_CHAR(IID_ICommand),
		& VALUE_CHAR(IID_ICommandProperties),
		& VALUE_CHAR(IID_ICommandText),
		& VALUE_CHAR(IID_IConvertType),
		& VALUE_CHAR(IID_IColumnsRowset),
		& VALUE_CHAR(IID_ICommandPrepare),
		& VALUE_CHAR(IID_ICommandWithParameters),
	
	//TRowset
		& VALUE_CHAR(IID_IRowset),
		& VALUE_CHAR(IID_IRowsetInfo),
		& VALUE_CHAR(IID_IColumnsRowset),
		& VALUE_CHAR(IID_IConnectionPointContainer),
		& VALUE_CHAR(IID_IRowsetChange),
		& VALUE_CHAR(IID_IRowsetIdentity),
		& VALUE_CHAR(IID_IRowsetLocate),
		& VALUE_CHAR(IID_IRowsetFind),
		& VALUE_CHAR(IID_IRowsetView),
		& VALUE_CHAR(IID_IChapteredRowset),
		& VALUE_CHAR(IID_IRowsetResynch),
		& VALUE_CHAR(IID_IRowsetScroll),
		& VALUE_CHAR(IID_IRowsetUpdate),

	//TTransaction
		& VALUE_CHAR(IID_ITransaction),
		& VALUE_CHAR(IID_ITransactionOptions),

	//TMultipleResults
		& VALUE_CHAR(IID_IMultipleResults),

	//TView
		& VALUE_CHAR(IID_IViewChapter),
//		& VALUE_CHAR(IID_IViewFilter),
		& VALUE_CHAR(IID_IViewRowset),
		& VALUE_CHAR(IID_IViewSort),

	//TIndex
		& VALUE_CHAR(IID_IRowsetIndex),
	
	//TError
		& VALUE_CHAR(IID_IErrorInfo),
		& VALUE_CHAR(IID_IErrorRecords),
		& VALUE_CHAR(IID_ISQLErrorInfo),

	//Connection Points
		& VALUE_CHAR(IID_IConnectionPoint),
		& VALUE_CHAR(IID_IRowsetNotify),
		& VALUE_CHAR(IID_IDBAsynchNotify),
		& VALUE_CHAR(IID_IRowPositionChange),

	//Misc
		& VALUE_CHAR(IID_IRowPosition),
		& VALUE_CHAR(IID_ISequentialStream),

	//Service Components
		& VALUE_CHAR(IID_IDBPromptInitialize),
		& VALUE_CHAR(IID_IDataInitialize),

	//Aggregation
		& VALUE_CHAR(IID_IAggregate),

	//IUnknown
		& VALUE_CHAR(IID_IUnknown),
		& VALUE_CHAR(IID_NULL),
};
const static ULONG g_cInterfaceMaps = NUMELE(g_rgInterfaceMap);


////////////////////////////////////////////////////////////////////////
// rgDBTypes
//
////////////////////////////////////////////////////////////////////////
const static WIDENAMEMAP g_rgDBTypes[] = 
{
    VALUE_WCHAR(DBTYPE_EMPTY	),
	VALUE_WCHAR(DBTYPE_NULL	),
	VALUE_WCHAR(DBTYPE_I2	),
	VALUE_WCHAR(DBTYPE_I4	),
	VALUE_WCHAR(DBTYPE_R4	),
	VALUE_WCHAR(DBTYPE_R8	),
	VALUE_WCHAR(DBTYPE_CY	),
	VALUE_WCHAR(DBTYPE_DATE	),
	VALUE_WCHAR(DBTYPE_BSTR	),
	VALUE_WCHAR(DBTYPE_IDISPATCH	),
	VALUE_WCHAR(DBTYPE_ERROR	),
	VALUE_WCHAR(DBTYPE_BOOL	),
	VALUE_WCHAR(DBTYPE_VARIANT	),
	VALUE_WCHAR(DBTYPE_IUNKNOWN	),
	VALUE_WCHAR(DBTYPE_DECIMAL	),
	VALUE_WCHAR(DBTYPE_UI1	),
	VALUE_WCHAR(DBTYPE_ARRAY	),
	VALUE_WCHAR(DBTYPE_BYREF	),
	VALUE_WCHAR(DBTYPE_I1	),
	VALUE_WCHAR(DBTYPE_UI2	),
	VALUE_WCHAR(DBTYPE_UI4	),
	VALUE_WCHAR(DBTYPE_I8	),
	VALUE_WCHAR(DBTYPE_UI8	),
	VALUE_WCHAR(DBTYPE_GUID	),
	VALUE_WCHAR(DBTYPE_VECTOR	),
	VALUE_WCHAR(DBTYPE_RESERVED	),
	VALUE_WCHAR(DBTYPE_BYTES	),
	VALUE_WCHAR(DBTYPE_STR	),
	VALUE_WCHAR(DBTYPE_WSTR	),
	VALUE_WCHAR(DBTYPE_NUMERIC	),
	VALUE_WCHAR(DBTYPE_UDT	),
	VALUE_WCHAR(DBTYPE_DBDATE	),
	VALUE_WCHAR(DBTYPE_DBTIME	),
	VALUE_WCHAR(DBTYPE_DBTIMESTAMP	),
	VALUE_WCHAR(DBTYPE_HCHAPTER	),

	//2.0 Types
	VALUE_WCHAR(DBTYPE_FILETIME	),
	VALUE_WCHAR(DBTYPE_PROPVARIANT	),
	VALUE_WCHAR(DBTYPE_VARNUMERIC	),
};
const static ULONG g_cDBTypes = NUMELE(g_rgDBTypes);


////////////////////////////////////////////////////////////////////////
// rgVariantTypes
//
////////////////////////////////////////////////////////////////////////
const static NAMEMAP g_rgVariantTypes[] = 
{
    VALUE_CHAR(VT_EMPTY	),
	VALUE_CHAR(VT_NULL	),
	VALUE_CHAR(VT_I2	),
	VALUE_CHAR(VT_I4	),
	VALUE_CHAR(VT_R4	),
	VALUE_CHAR(VT_R8	),
	VALUE_CHAR(VT_CY	),
	VALUE_CHAR(VT_DATE	),
	VALUE_CHAR(VT_BSTR	),
	VALUE_CHAR(VT_DISPATCH	),
	VALUE_CHAR(VT_ERROR	),
	VALUE_CHAR(VT_BOOL	),
	VALUE_CHAR(VT_VARIANT	),
	VALUE_CHAR(VT_UNKNOWN	),
	VALUE_CHAR(VT_DECIMAL	),
	VALUE_CHAR(VT_I1	),
	VALUE_CHAR(VT_UI1	),
	VALUE_CHAR(VT_UI2	),
	VALUE_CHAR(VT_UI4	),
	VALUE_CHAR(VT_I8	),
	VALUE_CHAR(VT_UI8	),
	VALUE_CHAR(VT_INT	),
	VALUE_CHAR(VT_UINT	),
	VALUE_CHAR(VT_VOID	),
	VALUE_CHAR(VT_HRESULT	),
	VALUE_CHAR(VT_PTR	),
	VALUE_CHAR(VT_SAFEARRAY	),
	VALUE_CHAR(VT_CARRAY	),
	VALUE_CHAR(VT_USERDEFINED	),
	VALUE_CHAR(VT_LPSTR	),
	VALUE_CHAR(VT_LPWSTR	),
	VALUE_CHAR(VT_FILETIME	),
	VALUE_CHAR(VT_BLOB	),
	VALUE_CHAR(VT_STREAM	),
	VALUE_CHAR(VT_STORAGE	),
	VALUE_CHAR(VT_STREAMED_OBJECT	),
	VALUE_CHAR(VT_STORED_OBJECT	),
	VALUE_CHAR(VT_BLOB_OBJECT	),
	VALUE_CHAR(VT_CF	),
	VALUE_CHAR(VT_CLSID	),
	VALUE_CHAR(VT_VECTOR	),
	VALUE_CHAR(VT_ARRAY	),
	VALUE_CHAR(VT_BYREF	),
	VALUE_CHAR(VT_RESERVED	),
	VALUE_CHAR(VT_ILLEGAL	),
	VALUE_CHAR(VT_ILLEGALMASKED	),
	VALUE_CHAR(VT_TYPEMASK	),
};
const static ULONG g_cVariantTypes = NUMELE(g_rgVariantTypes);


////////////////////////////////////////////////////////////////////////
// ERRORMAP
//
////////////////////////////////////////////////////////////////////////
const static WIDENAMEMAP g_rgErrorMap[] =
{
	 //System Success
	 VALUE_WCHAR(S_OK),
	 VALUE_WCHAR(S_FALSE),

	 //System Errors
	 VALUE_WCHAR(E_FAIL),
	 VALUE_WCHAR(E_INVALIDARG),
	 VALUE_WCHAR(E_OUTOFMEMORY),
	 VALUE_WCHAR(E_NOINTERFACE),
	 VALUE_WCHAR(REGDB_E_CLASSNOTREG),
	 VALUE_WCHAR(CLASS_E_NOAGGREGATION),
     VALUE_WCHAR(E_UNEXPECTED),
     VALUE_WCHAR(E_NOTIMPL),
     VALUE_WCHAR(E_POINTER),
     VALUE_WCHAR(E_HANDLE),
     VALUE_WCHAR(E_ABORT),
     VALUE_WCHAR(E_ACCESSDENIED),
     VALUE_WCHAR(E_PENDING),

	 //OLE DB Warnings 1.1
     VALUE_WCHAR(DB_S_ROWLIMITEXCEEDED),
     VALUE_WCHAR(DB_S_COLUMNTYPEMISMATCH),
     VALUE_WCHAR(DB_S_TYPEINFOOVERRIDDEN),
     VALUE_WCHAR(DB_S_BOOKMARKSKIPPED),
     VALUE_WCHAR(DB_S_ENDOFROWSET),
     VALUE_WCHAR(DB_S_COMMANDREEXECUTED),
     VALUE_WCHAR(DB_S_BUFFERFULL),
     VALUE_WCHAR(DB_S_NORESULT),
     VALUE_WCHAR(DB_S_CANTRELEASE),
     VALUE_WCHAR(DB_S_DIALECTIGNORED),
     VALUE_WCHAR(DB_S_UNWANTEDPHASE),
     VALUE_WCHAR(DB_S_UNWANTEDREASON),
     VALUE_WCHAR(DB_S_COLUMNSCHANGED),
     VALUE_WCHAR(DB_S_ERRORSRETURNED),
     VALUE_WCHAR(DB_S_BADROWHANDLE),
     VALUE_WCHAR(DB_S_DELETEDROW),
     VALUE_WCHAR(DB_S_STOPLIMITREACHED),
     VALUE_WCHAR(DB_S_LOCKUPGRADED),
     VALUE_WCHAR(DB_S_PROPERTIESCHANGED),
     VALUE_WCHAR(DB_S_ERRORSOCCURRED),
     VALUE_WCHAR(DB_S_PARAMUNAVAILABLE),
     VALUE_WCHAR(DB_S_MULTIPLECHANGES),

	 //OLE DB Errors 1.1
     VALUE_WCHAR(DB_E_BADACCESSORHANDLE),
     VALUE_WCHAR(DB_E_ROWLIMITEXCEEDED),
     VALUE_WCHAR(DB_E_READONLYACCESSOR),
     VALUE_WCHAR(DB_E_SCHEMAVIOLATION),
     VALUE_WCHAR(DB_E_BADROWHANDLE),
     VALUE_WCHAR(DB_E_OBJECTOPEN),
     VALUE_WCHAR(DB_E_CANTCONVERTVALUE),
     VALUE_WCHAR(DB_E_BADBINDINFO),
     VALUE_WCHAR(DB_SEC_E_PERMISSIONDENIED),
     VALUE_WCHAR(DB_E_NOTAREFERENCECOLUMN),
     VALUE_WCHAR(DB_E_NOCOMMAND),
     VALUE_WCHAR(DB_E_BADBOOKMARK),
     VALUE_WCHAR(DB_E_BADLOCKMODE),
     VALUE_WCHAR(DB_E_PARAMNOTOPTIONAL),
     VALUE_WCHAR(DB_E_BADCOLUMNID),
     VALUE_WCHAR(DB_E_BADRATIO),
     VALUE_WCHAR(DB_E_ERRORSINCOMMAND),
     VALUE_WCHAR(DB_E_CANTCANCEL),
     VALUE_WCHAR(DB_E_DIALECTNOTSUPPORTED),
     VALUE_WCHAR(DB_E_DUPLICATEDATASOURCE),
     VALUE_WCHAR(DB_E_CANNOTRESTART),
     VALUE_WCHAR(DB_E_NOTFOUND),
     VALUE_WCHAR(DB_E_NEWLYINSERTED),
     VALUE_WCHAR(DB_E_UNSUPPORTEDCONVERSION),
     VALUE_WCHAR(DB_E_BADSTARTPOSITION),
     VALUE_WCHAR(DB_E_NOTREENTRANT),
     VALUE_WCHAR(DB_E_ERRORSOCCURRED),
     VALUE_WCHAR(DB_E_NOAGGREGATION),
     VALUE_WCHAR(DB_E_DELETEDROW),
     VALUE_WCHAR(DB_E_CANTFETCHBACKWARDS),
     VALUE_WCHAR(DB_E_ROWSNOTRELEASED),
     VALUE_WCHAR(DB_E_BADSTORAGEFLAG),
     VALUE_WCHAR(DB_E_BADSTATUSVALUE),
     VALUE_WCHAR(DB_E_CANTSCROLLBACKWARDS),
     VALUE_WCHAR(DB_E_MULTIPLESTATEMENTS),
     VALUE_WCHAR(DB_E_INTEGRITYVIOLATION),
     VALUE_WCHAR(DB_E_BADTYPENAME),
     VALUE_WCHAR(DB_E_ABORTLIMITREACHED),
     VALUE_WCHAR(DB_E_DUPLICATEINDEXID),
     VALUE_WCHAR(DB_E_NOINDEX),
     VALUE_WCHAR(DB_E_INDEXINUSE),
     VALUE_WCHAR(DB_E_NOTABLE),
     VALUE_WCHAR(DB_E_CONCURRENCYVIOLATION),
     VALUE_WCHAR(DB_E_BADCOPY),
     VALUE_WCHAR(DB_E_BADPRECISION),
     VALUE_WCHAR(DB_E_BADSCALE),
     VALUE_WCHAR(DB_E_BADID),
     VALUE_WCHAR(DB_E_BADTYPE),
     VALUE_WCHAR(DB_E_DUPLICATECOLUMNID),
     VALUE_WCHAR(DB_E_DUPLICATETABLEID),
     VALUE_WCHAR(DB_E_TABLEINUSE),
     VALUE_WCHAR(DB_E_NOLOCALE),
     VALUE_WCHAR(DB_E_BADRECORDNUM),
     VALUE_WCHAR(DB_E_BOOKMARKSKIPPED),
     VALUE_WCHAR(DB_E_BADPROPERTYVALUE),
     VALUE_WCHAR(DB_E_INVALID),
     VALUE_WCHAR(DB_E_BADACCESSORFLAGS),
     VALUE_WCHAR(DB_E_BADSTORAGEFLAGS),
     VALUE_WCHAR(DB_E_BYREFACCESSORNOTSUPPORTED),
     VALUE_WCHAR(DB_E_NULLACCESSORNOTSUPPORTED),
     VALUE_WCHAR(DB_E_NOTPREPARED),
     VALUE_WCHAR(DB_E_BADACCESSORTYPE),
     VALUE_WCHAR(DB_E_WRITEONLYACCESSOR),
     VALUE_WCHAR(DB_SEC_E_AUTH_FAILED),
     VALUE_WCHAR(DB_E_CANCELED),
     VALUE_WCHAR(DB_E_BADSOURCEHANDLE),
     VALUE_WCHAR(DB_E_PARAMUNAVAILABLE),
     VALUE_WCHAR(DB_E_ALREADYINITIALIZED),
     VALUE_WCHAR(DB_E_NOTSUPPORTED),
     VALUE_WCHAR(DB_E_MAXPENDCHANGESEXCEEDED),
     VALUE_WCHAR(DB_E_BADORDINAL),
     VALUE_WCHAR(DB_E_PENDINGCHANGES),
     VALUE_WCHAR(DB_E_DATAOVERFLOW),
     VALUE_WCHAR(DB_E_BADHRESULT),
     VALUE_WCHAR(DB_E_BADLOOKUPID),
     VALUE_WCHAR(DB_E_BADDYNAMICERRORID),
     VALUE_WCHAR(DB_E_PENDINGINSERT),
     VALUE_WCHAR(DB_E_BADCONVERTFLAG),
     VALUE_WCHAR(DB_E_BADPARAMETERNAME),
     VALUE_WCHAR(DB_E_MULTIPLESTORAGE),
     VALUE_WCHAR(DB_E_CANTFILTER),
     VALUE_WCHAR(DB_E_CANTORDER),

	 //OLE DB Warnings 1.5
     VALUE_WCHAR(DB_S_ASYNCHRONOUS),
     VALUE_WCHAR(DB_S_UNWANTEDOPERATION),

	 //OLE DB Errors 1.5
     VALUE_WCHAR(DB_E_BADCHAPTER),
	 VALUE_WCHAR(DB_E_BADCOMPAREOP),

	 //OLE DB Warnings 2.0
	 VALUE_WCHAR(DB_S_NONEXTROWSET),

	 //OLE DB Errors 2.0
	 VALUE_WCHAR(DB_E_BADVALUES),
	 VALUE_WCHAR(DB_E_NOQUERY),
	 VALUE_WCHAR(DB_E_ROWSETINCOMMAND),
	 VALUE_WCHAR(DB_E_CANTTRANSLATE),
	 VALUE_WCHAR(DB_E_CHAPTERNOTRELEASED),

	 VALUE_WCHAR(MD_E_BADTUPLE),
	 VALUE_WCHAR(MD_E_BADCOORDINATE),
	 VALUE_WCHAR(MD_E_INVALIDAXIS),
	 VALUE_WCHAR(MD_E_INVALIDCELLRANGE),
	 VALUE_WCHAR(DB_E_NOCOLUMN),
	 VALUE_WCHAR(DB_E_COMMANDNOTPERSISTED),
	 VALUE_WCHAR(DB_E_DUPLICATEID),
	 VALUE_WCHAR(DB_E_OBJECTCREATIONLIMITREACHED),
	 VALUE_WCHAR(DB_E_BADINDEXID),

	 //Transactions
	 VALUE_WCHAR(XACT_E_FIRST                    ),
	 VALUE_WCHAR(XACT_E_LAST                     ),
	 VALUE_WCHAR(XACT_S_FIRST                    ),
	 VALUE_WCHAR(XACT_S_LAST                     ),

	 VALUE_WCHAR(XACT_E_ABORTED                  ),
	 VALUE_WCHAR(XACT_E_ALREADYOTHERSINGLEPHASE  ),
	 VALUE_WCHAR(XACT_E_ALREADYINPROGRESS        ),
	 VALUE_WCHAR(XACT_E_CANTRETAIN               ),
	 VALUE_WCHAR(XACT_E_COMMITFAILED             ),
	 VALUE_WCHAR(XACT_E_COMMITPREVENTED          ),
	 VALUE_WCHAR(XACT_E_CONNECTION_DENIED        ),
	 VALUE_WCHAR(XACT_E_CONNECTION_DOWN          ),
	 VALUE_WCHAR(XACT_E_HEURISTICABORT           ),
	 VALUE_WCHAR(XACT_E_HEURISTICCOMMIT          ),
	 VALUE_WCHAR(XACT_E_HEURISTICDAMAGE          ),
	 VALUE_WCHAR(XACT_E_HEURISTICDANGER          ),
	 VALUE_WCHAR(XACT_E_INDOUBT                  ),
	 VALUE_WCHAR(XACT_E_INVALIDCOOKIE            ),
	 VALUE_WCHAR(XACT_E_ISOLATIONLEVEL           ),
	 VALUE_WCHAR(XACT_E_LOGFULL                  ),
	 VALUE_WCHAR(XACT_E_NOASYNC                  ),
	 VALUE_WCHAR(XACT_E_NOENLIST                 ),
	 VALUE_WCHAR(XACT_E_NOIMPORTOBJECT           ),
	 VALUE_WCHAR(XACT_E_NOISORETAIN              ),
	 VALUE_WCHAR(XACT_E_NORESOURCE               ),
	 VALUE_WCHAR(XACT_E_NOTCURRENT               ),
	 VALUE_WCHAR(XACT_E_NOTIMEOUT                ),
	 VALUE_WCHAR(XACT_E_NOTRANSACTION            ),
	 VALUE_WCHAR(XACT_E_NOTSUPPORTED             ),
	 VALUE_WCHAR(XACT_E_REENLISTTIMEOUT          ),
	 VALUE_WCHAR(XACT_E_TMNOTAVAILABLE           ),
	 VALUE_WCHAR(XACT_E_UNKNOWNRMGRID            ),
	 VALUE_WCHAR(XACT_E_WRONGSTATE               ),
	 VALUE_WCHAR(XACT_E_WRONGUOW                 ),
	 VALUE_WCHAR(XACT_E_XTIONEXISTS              ),

	 VALUE_WCHAR(XACT_S_ABORTING                 ),
	 VALUE_WCHAR(XACT_S_ALLNORETAIN              ),
	 VALUE_WCHAR(XACT_S_ASYNC                    ),
	 VALUE_WCHAR(XACT_S_DEFECT                   ),
	 VALUE_WCHAR(XACT_S_OKINFORM                 ),
	 VALUE_WCHAR(XACT_S_MADECHANGESCONTENT       ),
	 VALUE_WCHAR(XACT_S_MADECHANGESINFORM        ),
	 VALUE_WCHAR(XACT_S_READONLY                 ),
	 VALUE_WCHAR(XACT_S_SINGLEPHASE              ),
	 VALUE_WCHAR(XACT_S_SOMENORETAIN             ),

	 //Com Errors
	 VALUE_WCHAR(CO_E_NOTINITIALIZED              ),
	 VALUE_WCHAR(CO_E_ALREADYINITIALIZED          ),
	 VALUE_WCHAR(CO_E_CANTDETERMINECLASS          ),
	 VALUE_WCHAR(CO_E_CLASSSTRING                 ),
	 VALUE_WCHAR(CO_E_IIDSTRING                   ),
	 VALUE_WCHAR(CO_E_APPNOTFOUND                 ),
	 VALUE_WCHAR(CO_E_APPSINGLEUSE                ),
	 VALUE_WCHAR(CO_E_ERRORINAPP                  ),
	 VALUE_WCHAR(CO_E_DLLNOTFOUND                 ),
	 VALUE_WCHAR(CO_E_ERRORINDLL                  ),
	 VALUE_WCHAR(CO_E_WRONGOSFORAPP               ),
	 VALUE_WCHAR(CO_E_OBJNOTREG                   ),
	 VALUE_WCHAR(CO_E_OBJISREG                    ),
	 VALUE_WCHAR(CO_E_OBJNOTCONNECTED             ),
	 VALUE_WCHAR(CO_E_APPDIDNTREG                 ),
	 VALUE_WCHAR(CO_E_RELEASED                    ),

	 //Moniker Errors
	 VALUE_WCHAR(MK_E_CONNECTMANUALLY             ),
	 VALUE_WCHAR(MK_E_EXCEEDEDDEADLINE            ),
	 VALUE_WCHAR(MK_E_NEEDGENERIC                 ),
	 VALUE_WCHAR(MK_E_UNAVAILABLE                 ),
	 VALUE_WCHAR(MK_E_SYNTAX                      ),
	 VALUE_WCHAR(MK_E_NOOBJECT                    ),
	 VALUE_WCHAR(MK_E_INVALIDEXTENSION            ),
	 VALUE_WCHAR(MK_E_INTERMEDIATEINTERFACENOTSUPPORTED ),
	 VALUE_WCHAR(MK_E_NOTBINDABLE                 ),
	 VALUE_WCHAR(MK_E_NOTBOUND                    ),
	 VALUE_WCHAR(MK_E_CANTOPENFILE                ),
	 VALUE_WCHAR(MK_E_MUSTBOTHERUSER              ),
	 VALUE_WCHAR(MK_E_NOINVERSE                   ),
	 VALUE_WCHAR(MK_E_NOSTORAGE                   ),
	 VALUE_WCHAR(MK_E_NOPREFIX                    ),
	 VALUE_WCHAR(MK_E_ENUMERATION_FAILED          ),

	 //Connection Points
	 VALUE_WCHAR(CONNECT_E_NOCONNECTION),
	 VALUE_WCHAR(CONNECT_E_ADVISELIMIT),
	 VALUE_WCHAR(CONNECT_E_CANNOTCONNECT),
	 VALUE_WCHAR(CONNECT_E_OVERRIDDEN),

	 //Dispatch/Variant Errors
	 VALUE_WCHAR(DISP_E_UNKNOWNINTERFACE),
	 VALUE_WCHAR(DISP_E_MEMBERNOTFOUND),
	 VALUE_WCHAR(DISP_E_PARAMNOTFOUND),
	 VALUE_WCHAR(DISP_E_TYPEMISMATCH),
	 VALUE_WCHAR(DISP_E_UNKNOWNNAME),
	 VALUE_WCHAR(DISP_E_NONAMEDARGS),
	 VALUE_WCHAR(DISP_E_BADVARTYPE),
	 VALUE_WCHAR(DISP_E_EXCEPTION),
	 VALUE_WCHAR(DISP_E_OVERFLOW),
	 VALUE_WCHAR(DISP_E_BADINDEX),
	 VALUE_WCHAR(DISP_E_UNKNOWNLCID),
	 VALUE_WCHAR(DISP_E_ARRAYISLOCKED),
	 VALUE_WCHAR(DISP_E_BADPARAMCOUNT),
	 VALUE_WCHAR(DISP_E_PARAMNOTOPTIONAL),
	 VALUE_WCHAR(DISP_E_BADCALLEE),
	 VALUE_WCHAR(DISP_E_NOTACOLLECTION),

	 //DataSource Locator Errors
	 VALUE_WCHAR(DB_E_BADINITSTRING),
	 VALUE_WCHAR(DB_E_NOPROVIDERSREGISTERED),
	 VALUE_WCHAR(DB_E_MISMATCHEDPROVIDER),
};


////////////////////////////////////////////////////////////////////////
// PROPSTATUSMAP
//
////////////////////////////////////////////////////////////////////////
const static WIDENAMEMAP g_rgPropStatusMap[] =
{
    VALUE_WCHAR(DBPROPSTATUS_OK),
	VALUE_WCHAR(DBPROPSTATUS_NOTSUPPORTED),
	VALUE_WCHAR(DBPROPSTATUS_BADVALUE),
	VALUE_WCHAR(DBPROPSTATUS_BADOPTION),
	VALUE_WCHAR(DBPROPSTATUS_BADCOLUMN),
	VALUE_WCHAR(DBPROPSTATUS_NOTALLSETTABLE),
	VALUE_WCHAR(DBPROPSTATUS_NOTSETTABLE),
	VALUE_WCHAR(DBPROPSTATUS_NOTSET),
	VALUE_WCHAR(DBPROPSTATUS_CONFLICTING),
};


////////////////////////////////////////////////////////////////////////
// STATUSMAP
//
////////////////////////////////////////////////////////////////////////
const static NAMEMAP g_rgStatusMap[] =
{
    VALUE_CHAR(DBSTATUS_S_OK	),
	VALUE_CHAR(DBSTATUS_E_BADACCESSOR	),
	VALUE_CHAR(DBSTATUS_E_CANTCONVERTVALUE	),
	VALUE_CHAR(DBSTATUS_S_ISNULL	),
	VALUE_CHAR(DBSTATUS_S_TRUNCATED	),
	VALUE_CHAR(DBSTATUS_E_SIGNMISMATCH	),
	VALUE_CHAR(DBSTATUS_E_DATAOVERFLOW	),
	VALUE_CHAR(DBSTATUS_E_CANTCREATE	),
	VALUE_CHAR(DBSTATUS_E_UNAVAILABLE	),
	VALUE_CHAR(DBSTATUS_E_PERMISSIONDENIED	),
	VALUE_CHAR(DBSTATUS_E_INTEGRITYVIOLATION	),
	VALUE_CHAR(DBSTATUS_E_SCHEMAVIOLATION	),
	VALUE_CHAR(DBSTATUS_E_BADSTATUS	),
	VALUE_CHAR(DBSTATUS_S_DEFAULT	),

	//2.0
	VALUE_CHAR(MDSTATUS_S_CELLEMPTY	),
};


////////////////////////////////////////////////////////////////////////
// CHAR* GetStatusName
//
////////////////////////////////////////////////////////////////////////
CHAR* GetStatusName(DBSTATUS dwStatus)
{
	return GetMapName((LONG)dwStatus, NUMELE(g_rgStatusMap), g_rgStatusMap);
}

////////////////////////////////////////////////////////////////////////
// DBSTATUS GetStatusValue
//
////////////////////////////////////////////////////////////////////////
DBSTATUS GetStatusValue(CHAR* pszName)
{
	return GetMapName(pszName, NUMELE(g_rgStatusMap), g_rgStatusMap);
}

////////////////////////////////////////////////////////////////////////
// PROPSET
//
////////////////////////////////////////////////////////////////////////
const static GUIDMAP g_rgPropSetMap[] =
{
	//Property Sets
	& VALUE_CHAR(DBPROPSET_COLUMN),
	& VALUE_CHAR(DBPROPSET_DATASOURCE),
	& VALUE_CHAR(DBPROPSET_DATASOURCEINFO),
	& VALUE_CHAR(DBPROPSET_DBINIT),
	& VALUE_CHAR(DBPROPSET_DBINITALL),
	& VALUE_CHAR(DBPROPSET_INDEX),
	& VALUE_CHAR(DBPROPSET_TABLE),
	& VALUE_CHAR(DBPROPSET_VIEW),
	& VALUE_CHAR(DBPROPSET_DATASOURCEALL),
	& VALUE_CHAR(DBPROPSET_DATASOURCEINFOALL),
	& VALUE_CHAR(DBPROPSET_ROWSET),
	& VALUE_CHAR(DBPROPSET_ROWSETALL),
	& VALUE_CHAR(DBPROPSET_SESSION),
	& VALUE_CHAR(DBPROPSET_SESSIONALL),
	& VALUE_CHAR(DBPROPSET_PROPERTIESINERROR),
};
const static ULONG g_cPropSetMaps = NUMELE(g_rgPropSetMap);


////////////////////////////////////////////////////////////////////////
// PROPMAP
//
////////////////////////////////////////////////////////////////////////
const static NAMEMAP g_rgOLEDBPropMap[] =
{
	VALUE_CHAR(DBPROP_ABORTPRESERVE	),
	VALUE_CHAR(DBPROP_ACTIVESESSIONS	),
	VALUE_CHAR(DBPROP_APPENDONLY	),
	VALUE_CHAR(DBPROP_ASYNCTXNABORT	),
	VALUE_CHAR(DBPROP_ASYNCTXNCOMMIT	),
	VALUE_CHAR(DBPROP_AUTH_CACHE_AUTHINFO	),
	VALUE_CHAR(DBPROP_AUTH_ENCRYPT_PASSWORD	),
	VALUE_CHAR(DBPROP_AUTH_INTEGRATED	),
	VALUE_CHAR(DBPROP_AUTH_MASK_PASSWORD	),
	VALUE_CHAR(DBPROP_AUTH_PASSWORD	),
	VALUE_CHAR(DBPROP_AUTH_PERSIST_ENCRYPTED	),
	VALUE_CHAR(DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO	),
	VALUE_CHAR(DBPROP_AUTH_USERID	),
	VALUE_CHAR(DBPROP_BLOCKINGSTORAGEOBJECTS	),
	VALUE_CHAR(DBPROP_BOOKMARKS	),
	VALUE_CHAR(DBPROP_BOOKMARKSKIPPED	),
	VALUE_CHAR(DBPROP_BOOKMARKTYPE	),
	VALUE_CHAR(DBPROP_BYREFACCESSORS	),
	VALUE_CHAR(DBPROP_CACHEDEFERRED	),
	VALUE_CHAR(DBPROP_CANFETCHBACKWARDS	),
	VALUE_CHAR(DBPROP_CANHOLDROWS	),
	VALUE_CHAR(DBPROP_CANSCROLLBACKWARDS	),
	VALUE_CHAR(DBPROP_CATALOGLOCATION	),
	VALUE_CHAR(DBPROP_CATALOGTERM	),
	VALUE_CHAR(DBPROP_CATALOGUSAGE	),
	VALUE_CHAR(DBPROP_CHANGEINSERTEDROWS	),
	VALUE_CHAR(DBPROP_COL_AUTOINCREMENT	),
	VALUE_CHAR(DBPROP_COL_DEFAULT	),
	VALUE_CHAR(DBPROP_COL_DESCRIPTION	),
	VALUE_CHAR(DBPROP_COL_FIXEDLENGTH	),
	VALUE_CHAR(DBPROP_COL_NULLABLE	),
	VALUE_CHAR(DBPROP_COL_PRIMARYKEY	),
	VALUE_CHAR(DBPROP_COL_UNIQUE	),
	VALUE_CHAR(DBPROP_COLUMNDEFINITION	),
	VALUE_CHAR(DBPROP_COLUMNRESTRICT	),
	VALUE_CHAR(DBPROP_COMMANDTIMEOUT	),
	VALUE_CHAR(DBPROP_COMMITPRESERVE	),
	VALUE_CHAR(DBPROP_CONCATNULLBEHAVIOR	),
	VALUE_CHAR(DBPROP_CURRENTCATALOG	),
	VALUE_CHAR(DBPROP_DATASOURCENAME	),
	VALUE_CHAR(DBPROP_DATASOURCEREADONLY	),
	VALUE_CHAR(DBPROP_DBMSNAME	),
	VALUE_CHAR(DBPROP_DBMSVER	),
	VALUE_CHAR(DBPROP_DEFERRED	),
	VALUE_CHAR(DBPROP_DELAYSTORAGEOBJECTS	),
	VALUE_CHAR(DBPROP_DSOTHREADMODEL	),
	VALUE_CHAR(DBPROP_GROUPBY	),
	VALUE_CHAR(DBPROP_HETEROGENEOUSTABLES	),
	VALUE_CHAR(DBPROP_IAccessor	),
	VALUE_CHAR(DBPROP_IColumnsInfo	),
	VALUE_CHAR(DBPROP_IColumnsRowset	),
	VALUE_CHAR(DBPROP_IConnectionPointContainer	),
	VALUE_CHAR(DBPROP_IConvertType	),
	VALUE_CHAR(DBPROP_IRowset	),
	VALUE_CHAR(DBPROP_IRowsetChange	),
	VALUE_CHAR(DBPROP_IRowsetIdentity),
	VALUE_CHAR(DBPROP_IRowsetIndex),
	VALUE_CHAR(DBPROP_IRowsetInfo),
	VALUE_CHAR(DBPROP_IRowsetLocate),
	VALUE_CHAR(DBPROP_IRowsetResynch),
	VALUE_CHAR(DBPROP_IRowsetScroll),
	VALUE_CHAR(DBPROP_IRowsetUpdate),
	VALUE_CHAR(DBPROP_ISupportErrorInfo),
	VALUE_CHAR(DBPROP_ILockBytes),
	VALUE_CHAR(DBPROP_ISequentialStream),
	VALUE_CHAR(DBPROP_IStorage),
	VALUE_CHAR(DBPROP_IStream),
	VALUE_CHAR(DBPROP_IDENTIFIERCASE),
	VALUE_CHAR(DBPROP_IMMOBILEROWS),
	VALUE_CHAR(DBPROP_INDEX_AUTOUPDATE),
	VALUE_CHAR(DBPROP_INDEX_CLUSTERED),
	VALUE_CHAR(DBPROP_INDEX_FILLFACTOR),
	VALUE_CHAR(DBPROP_INDEX_INITIALSIZE),
	VALUE_CHAR(DBPROP_INDEX_NULLCOLLATION),
	VALUE_CHAR(DBPROP_INDEX_NULLS),
	VALUE_CHAR(DBPROP_INDEX_PRIMARYKEY),
	VALUE_CHAR(DBPROP_INDEX_SORTBOOKMARKS),
	VALUE_CHAR(DBPROP_INDEX_TEMPINDEX),
	VALUE_CHAR(DBPROP_INDEX_TYPE),
	VALUE_CHAR(DBPROP_INDEX_UNIQUE),
	VALUE_CHAR(DBPROP_INIT_DATASOURCE),
	VALUE_CHAR(DBPROP_INIT_HWND	),
	VALUE_CHAR(DBPROP_INIT_IMPERSONATION_LEVEL	),
	VALUE_CHAR(DBPROP_INIT_LCID	),
	VALUE_CHAR(DBPROP_INIT_LOCATION	),
	VALUE_CHAR(DBPROP_INIT_MODE	),
	VALUE_CHAR(DBPROP_INIT_PROMPT	),
	VALUE_CHAR(DBPROP_INIT_PROTECTION_LEVEL	),
	VALUE_CHAR(DBPROP_INIT_PROVIDERSTRING	),
	VALUE_CHAR(DBPROP_INIT_TIMEOUT	),
	VALUE_CHAR(DBPROP_LITERALBOOKMARKS	),
	VALUE_CHAR(DBPROP_LITERALIDENTITY	),
	VALUE_CHAR(DBPROP_MARSHALLABLE	),
	VALUE_CHAR(DBPROP_MAXINDEXSIZE	),
	VALUE_CHAR(DBPROP_MAXOPENROWS	),
	VALUE_CHAR(DBPROP_MAXPENDINGROWS	),
	VALUE_CHAR(DBPROP_MAXROWS	),
	VALUE_CHAR(DBPROP_MAXROWSIZE	),
	VALUE_CHAR(DBPROP_MAXROWSIZEINCLUDESBLOB	),
	VALUE_CHAR(DBPROP_MAXTABLESINSELECT	),
	VALUE_CHAR(DBPROP_MAYWRITECOLUMN	),
	VALUE_CHAR(DBPROP_MEMORYUSAGE	),
	VALUE_CHAR(DBPROP_MULTIPLEPARAMSETS	),
	VALUE_CHAR(DBPROP_MULTIPLERESULTS	),
	VALUE_CHAR(DBPROP_MULTIPLESTORAGEOBJECTS	),
	VALUE_CHAR(DBPROP_MULTITABLEUPDATE	),
	VALUE_CHAR(DBPROP_NOTIFICATIONGRANULARITY	),
	VALUE_CHAR(DBPROP_NOTIFICATIONPHASES	),
	VALUE_CHAR(DBPROP_NOTIFYCOLUMNSET	),
	VALUE_CHAR(DBPROP_NOTIFYROWDELETE	),
	VALUE_CHAR(DBPROP_NOTIFYROWFIRSTCHANGE	),
	VALUE_CHAR(DBPROP_NOTIFYROWINSERT	),
	VALUE_CHAR(DBPROP_NOTIFYROWRESYNCH	),
	VALUE_CHAR(DBPROP_NOTIFYROWSETRELEASE	),
	VALUE_CHAR(DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE	),
	VALUE_CHAR(DBPROP_NOTIFYROWUNDOCHANGE	),
	VALUE_CHAR(DBPROP_NOTIFYROWUNDODELETE	),
	VALUE_CHAR(DBPROP_NOTIFYROWUNDOINSERT	),
	VALUE_CHAR(DBPROP_NOTIFYROWUPDATE	),
	VALUE_CHAR(DBPROP_NULLCOLLATION	),
	VALUE_CHAR(DBPROP_OLEOBJECTS	),
	VALUE_CHAR(DBPROP_ORDERBYCOLUMNSINSELECT	),
	VALUE_CHAR(DBPROP_ORDEREDBOOKMARKS	),
	VALUE_CHAR(DBPROP_OTHERINSERT	),
	VALUE_CHAR(DBPROP_OTHERUPDATEDELETE	),
	VALUE_CHAR(DBPROP_OUTPUTPARAMETERAVAILABILITY	),
	VALUE_CHAR(DBPROP_OWNINSERT	),
	VALUE_CHAR(DBPROP_OWNUPDATEDELETE	),
	VALUE_CHAR(DBPROP_PERSISTENTIDTYPE	),
	VALUE_CHAR(DBPROP_PREPAREABORTBEHAVIOR	),
	VALUE_CHAR(DBPROP_PREPARECOMMITBEHAVIOR	),
	VALUE_CHAR(DBPROP_PROCEDURETERM	),
	VALUE_CHAR(DBPROP_PROVIDERFILENAME	),
	VALUE_CHAR(DBPROP_PROVIDEROLEDBVER	),
	VALUE_CHAR(DBPROP_PROVIDERVER	),
	VALUE_CHAR(DBPROP_QUICKRESTART	),
	VALUE_CHAR(DBPROP_QUOTEDIDENTIFIERCASE	),
	VALUE_CHAR(DBPROP_REENTRANTEVENTS	),
	VALUE_CHAR(DBPROP_REMOVEDELETED	),
	VALUE_CHAR(DBPROP_REPORTMULTIPLECHANGES	),
	VALUE_CHAR(DBPROP_RETURNPENDINGINSERTS	),
	VALUE_CHAR(DBPROP_ROWRESTRICT	),
	VALUE_CHAR(DBPROP_ROWSETCONVERSIONSONCOMMAND	),
	VALUE_CHAR(DBPROP_ROWTHREADMODEL	),
	VALUE_CHAR(DBPROP_SCHEMATERM	),
	VALUE_CHAR(DBPROP_SCHEMAUSAGE	),
	VALUE_CHAR(DBPROP_SERVERCURSOR	),
	VALUE_CHAR(DBPROP_SESS_AUTOCOMMITISOLEVELS	),
	VALUE_CHAR(DBPROP_SQLSUPPORT	),
	VALUE_CHAR(DBPROP_STRONGIDENTITY	),
	VALUE_CHAR(DBPROP_STRUCTUREDSTORAGE	),
	VALUE_CHAR(DBPROP_SUBQUERIES	),
	VALUE_CHAR(DBPROP_SUPPORTEDTXNDDL	),
	VALUE_CHAR(DBPROP_SUPPORTEDTXNISOLEVELS	),
	VALUE_CHAR(DBPROP_SUPPORTEDTXNISORETAIN	),
	VALUE_CHAR(DBPROP_TABLETERM	),
	VALUE_CHAR(DBPROP_TBL_TEMPTABLE	),
	VALUE_CHAR(DBPROP_TRANSACTEDOBJECT	),
	VALUE_CHAR(DBPROP_UPDATABILITY	),
	VALUE_CHAR(DBPROP_USERNAME	),
	VALUE_CHAR(DBPROP_FILTEROPS	),
	VALUE_CHAR(DBPROP_FILTERCOMPAREOPS	),
	VALUE_CHAR(DBPROP_FINDCOMPAREOPS	),
	VALUE_CHAR(DBPROP_IChapteredRowset	),
	VALUE_CHAR(DBPROP_IDBAsynchStatus	),
	VALUE_CHAR(DBPROP_IRowsetFind	),
	VALUE_CHAR(DBPROP_IRowsetView),
	VALUE_CHAR(DBPROP_IViewChapter),
	VALUE_CHAR(DBPROP_IViewFilter),
	VALUE_CHAR(DBPROP_IViewRowset),
	VALUE_CHAR(DBPROP_IViewSort),
	VALUE_CHAR(DBPROP_INIT_ASYNCH),
	VALUE_CHAR(DBPROP_MAXOPENCHAPTERS	),
	VALUE_CHAR(DBPROP_MAXORSINFILTER	),
	VALUE_CHAR(DBPROP_MAXSORTCOLUMNS	),
	VALUE_CHAR(DBPROP_ROWSET_ASYNCH	),
	VALUE_CHAR(DBPROP_SORTONINDEX	),

	//2.0
	VALUE_CHAR(DBPROP_IMultipleResults),
	VALUE_CHAR(DBPROP_DATASOURCE_TYPE),
	VALUE_CHAR(MDPROP_AXES),
	VALUE_CHAR(MDPROP_FLATTENING_SUPPORT),
	VALUE_CHAR(MDPROP_MDX_JOINCUBES),
	VALUE_CHAR(MDPROP_NAMED_LEVELS),
	VALUE_CHAR(MDPROP_RANGEROWSET),
	VALUE_CHAR(MDPROP_MDX_SLICER),
	VALUE_CHAR(MDPROP_MDX_CUBEQUALIFICATION),
	VALUE_CHAR(MDPROP_MDX_OUTERREFERENCE),
	VALUE_CHAR(MDPROP_MDX_QUERYBYPROPERTY),
	VALUE_CHAR(MDPROP_MDX_CASESUPPORT),
	VALUE_CHAR(MDPROP_MDX_STRING_COMPOP),
	VALUE_CHAR(MDPROP_MDX_DESCFLAGS),
	VALUE_CHAR(MDPROP_MDX_SET_FUNCTIONS),
	VALUE_CHAR(MDPROP_MDX_MEMBER_FUNCTIONS),
	VALUE_CHAR(MDPROP_MDX_NUMERIC_FUNCTIONS),
	VALUE_CHAR(MDPROP_MDX_FORMULAS),
	VALUE_CHAR(MDPROP_MDX_AGGREGATECELL_UPDATE),
	VALUE_CHAR(DBPROP_ACCESSORDER),
	VALUE_CHAR(DBPROP_BOOKMARKINFO),
	VALUE_CHAR(DBPROP_INIT_CATALOG),
	VALUE_CHAR(DBPROP_ROW_BULKOPS),
	VALUE_CHAR(DBPROP_PROVIDERFRIENDLYNAME),
	VALUE_CHAR(DBPROP_LOCKMODE),
	VALUE_CHAR(DBPROP_MULTIPLECONNECTIONS),
	VALUE_CHAR(DBPROP_UNIQUEROWS),
	VALUE_CHAR(DBPROP_SERVERDATAONINSERT),
	VALUE_CHAR(DBPROP_STORAGEFLAGS),
	VALUE_CHAR(DBPROP_CONNECTIONSTATUS),
	VALUE_CHAR(DBPROP_ALTERCOLUMN),
	VALUE_CHAR(DBPROP_COLUMNLCID),
	VALUE_CHAR(DBPROP_RESETDATASOURCE),
	VALUE_CHAR(DBPROP_INIT_OLEDBSERVICES),
	VALUE_CHAR(DBPROP_IRowsetRefresh),
	VALUE_CHAR(DBPROP_SERVERNAME),
	VALUE_CHAR(DBPROP_IParentRowset),
	VALUE_CHAR(DBPROP_HIDDENCOLUMNS),
	VALUE_CHAR(DBPROP_PROVIDERMEMORY),
	VALUE_CHAR(DBPROP_CLIENTCURSOR),
};


////////////////////////////////////////////////////////////////////////
// PROPFLAGS
//
////////////////////////////////////////////////////////////////////////
const static NAMEMAP g_rgPropFlagsMap[] =
{
    VALUE_CHAR(DBPROPFLAGS_NOTSUPPORTED	),
	VALUE_CHAR(DBPROPFLAGS_COLUMN	),
	VALUE_CHAR(DBPROPFLAGS_DATASOURCE	),
	VALUE_CHAR(DBPROPFLAGS_DATASOURCECREATE	),
	VALUE_CHAR(DBPROPFLAGS_DATASOURCEINFO	),
	VALUE_CHAR(DBPROPFLAGS_DBINIT	),
	VALUE_CHAR(DBPROPFLAGS_INDEX	),
	VALUE_CHAR(DBPROPFLAGS_ROWSET	),
	VALUE_CHAR(DBPROPFLAGS_TABLE	),
	VALUE_CHAR(DBPROPFLAGS_COLUMNOK	),
	VALUE_CHAR(DBPROPFLAGS_READ	),
	VALUE_CHAR(DBPROPFLAGS_WRITE	),
	VALUE_CHAR(DBPROPFLAGS_REQUIRED	),
	VALUE_CHAR(DBPROPFLAGS_SESSION	),
};


const static NAMEMAP g_rgIsoLevels[] =
{
	VALUE_CHAR(ISOLATIONLEVEL_UNSPECIFIED	),
	VALUE_CHAR(ISOLATIONLEVEL_CHAOS	),
	VALUE_CHAR(ISOLATIONLEVEL_READUNCOMMITTED	),
	VALUE_CHAR(ISOLATIONLEVEL_BROWSE	),
	VALUE_CHAR(ISOLATIONLEVEL_CURSORSTABILITY	),
	VALUE_CHAR(ISOLATIONLEVEL_READCOMMITTED	),
	VALUE_CHAR(ISOLATIONLEVEL_REPEATABLEREAD	),
	VALUE_CHAR(ISOLATIONLEVEL_SERIALIZABLE	),
	VALUE_CHAR(ISOLATIONLEVEL_ISOLATED	),
};
const static ULONG g_cIsoLevels = NUMELE(g_rgIsoLevels);


const static NAMEMAP g_rgXACTTC[] =
{	
	VALUE_CHAR(XACTTC_SYNC_PHASEONE	),
	VALUE_CHAR(XACTTC_SYNC_PHASETWO	),
	VALUE_CHAR(XACTTC_SYNC	),
	VALUE_CHAR(XACTTC_ASYNC_PHASEONE	),
};
const static ULONG g_cXACTTC = NUMELE(g_rgXACTTC);

			
////////////////////////////////////////////////////////////////////////
// CHAR* GetPropertyName
//
////////////////////////////////////////////////////////////////////////
CHAR* GetPropertyName(DBPROPID dwPropertyID, GUID guidPropertySet)
{
	//Thankfully all OLEDB Properties have different DBPROPIDs, (all unique)
	//The problem is that provider specific properties may not be.
	//So if we know the set we can find the property, otherwsie we don't know it...
	if(guidPropertySet == DBPROPSET_COLUMN ||
		guidPropertySet == DBPROPSET_DATASOURCE ||
		guidPropertySet == DBPROPSET_DATASOURCEINFO ||
		guidPropertySet == DBPROPSET_DBINIT ||
		guidPropertySet == DBPROPSET_INDEX || 
		guidPropertySet == DBPROPSET_ROWSET || 
		guidPropertySet == DBPROPSET_TABLE ||
		guidPropertySet == DBPROPSET_DATASOURCEALL ||
		guidPropertySet == DBPROPSET_DATASOURCEINFOALL ||
		guidPropertySet == DBPROPSET_ROWSETALL ||
		guidPropertySet == DBPROPSET_SESSION ||
		guidPropertySet == DBPROPSET_SESSIONALL ||
		guidPropertySet == DBPROPSET_DBINITALL ||
		guidPropertySet == DBPROPSET_PROPERTIESINERROR ||
		guidPropertySet == DBPROPSET_VIEW)
	{
		return GetMapName(dwPropertyID, NUMELE(g_rgOLEDBPropMap), g_rgOLEDBPropMap);
	}

	//Otherwise we have no clue what the property is...
	return NULL;
}




////////////////////////////////////////////////////////////////////////
// CHAR* GetPropSetName
//
////////////////////////////////////////////////////////////////////////
CHAR* GetPropSetName(GUID guidPropertySet)
{
	return GetMapName(guidPropertySet, g_cPropSetMaps, g_rgPropSetMap);
}

////////////////////////////////////////////////////////////////////////
// CHAR* GetMapName
//
////////////////////////////////////////////////////////////////////////
CHAR* GetMapName(LONG lItem, ULONG cNameMap, const NAMEMAP* rgNameMap)
{
	ASSERT(rgNameMap);
	for(ULONG i=0; i<cNameMap; i++)
	{
		if(lItem == rgNameMap[i].lItem) 
			return rgNameMap[i].pszName;
	}

	//Otherwise just return last element
	return NULL;
}


////////////////////////////////////////////////////////////////////////
// LONG GetMapName
//
////////////////////////////////////////////////////////////////////////
LONG GetMapName(WCHAR* pwsz, ULONG cNameMap, const WIDENAMEMAP* rgNameMap)
{
	ASSERT(pwsz);
	ASSERT(rgNameMap);
	for(ULONG i=0; i<cNameMap; i++)
	{
		if(wcscmp(pwsz, rgNameMap[i].pwszName)==0) 
			return rgNameMap[i].lItem;
	}

	//Otherwise just return last element
	return -1;
}

////////////////////////////////////////////////////////////////////////
// LONG GetMapName
//
////////////////////////////////////////////////////////////////////////
LONG GetMapName(CHAR* psz, ULONG cNameMap, const NAMEMAP* rgNameMap)
{
	ASSERT(psz);
	ASSERT(rgNameMap);
	for(ULONG i=0; i<cNameMap; i++)
	{
		if(strcmp(psz, rgNameMap[i].pszName)==0) 
			return rgNameMap[i].lItem;
	}

	//Otherwise just return last element
	return -1;
}


////////////////////////////////////////////////////////////////////////
// WCHAR* GetMapName
//
////////////////////////////////////////////////////////////////////////
WCHAR* GetMapName(LONG lItem, ULONG cNameMap, const WIDENAMEMAP* rgNameMap)
{
	ASSERT(rgNameMap);
	for(ULONG i=0; i<cNameMap; i++)
	{
		if(lItem == rgNameMap[i].lItem) 
			return rgNameMap[i].pwszName;
	}

	//Otherwise just return last element
	return NULL;
}

////////////////////////////////////////////////////////////////////////
// CHAR* GetMapName
//
////////////////////////////////////////////////////////////////////////
CHAR* GetMapName(GUID guid, ULONG cGuidMap, const GUIDMAP* rgGuidMap)
{
	for(ULONG i=0; i<cGuidMap; i++)	
	{
		if(guid == *(rgGuidMap[i].pGuid)) 
			return rgGuidMap[i].pszName;
	}

	//Otherwise just return last element
	return NULL;
}


////////////////////////////////////////////////////////////////////////
// WCHAR* GetErrorName
//
////////////////////////////////////////////////////////////////////////
WCHAR* GetErrorName(HRESULT hr)
{
	return GetMapName(hr, NUMELE(g_rgErrorMap), g_rgErrorMap);
}

////////////////////////////////////////////////////////////////////////
// CHAR* GetInterfaceName
//
////////////////////////////////////////////////////////////////////////
CHAR* GetInterfaceName(REFIID riid)
{
	return GetMapName(riid, NUMELE(g_rgInterfaceMap), g_rgInterfaceMap);
}



////////////////////////////////////////////////////////////////////////
// HRESULT DisplayBindingErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayBindingErrors(HWND hWnd, ULONG cBindings, DBBINDING* rgBindings, void* pData)
{
	//Display the badstatus for pData operations.
	//(ie:  GetData / SetData / InsertRow)
	HRESULT hr = S_OK;
	INT iSelect = 0;

	for(ULONG i=0; i<cBindings; i++)
	{
		ASSERT(pData);
		ASSERT(rgBindings);
		DBSTATUS dwStatus = BINDING_STATUS(rgBindings[i], pData);
		
		switch(dwStatus)
		{
			case DBSTATUS_S_OK:
			case DBSTATUS_S_ISNULL:
			case DBSTATUS_S_DEFAULT:
				break;

			//Display Status Error to the user...
			default:
			{	
				iSelect = wMessageBox(hWnd, MB_TASKMODAL | MB_ICONERROR | MB_OKCANCEL, wsz_ERROR, 
					L"Binding Status Errors:\n"
					L"rgBindings[%d]\n\n"
					L"iOrdinal = %d\n"
					L"wType = %s\n"
					L"cbMaxLen = %d\n"
					L"bPrecision = %d\n"
					L"bScale = %d\n\n"
					L"DBSTATUS = %S",
					i,
					rgBindings[i].iOrdinal,
					GetDBTypeName(rgBindings[i].wType),
					rgBindings[i].cbMaxLen,
					rgBindings[i].bPrecision,
					rgBindings[i].bScale,
					GetStatusName(dwStatus)
					);

				if(iSelect == IDCANCEL)
					goto CLEANUP;
				break;
			}
		}
	}

CLEANUP:
	return hr;
}


////////////////////////////////////////////////////////////////////////
// STATUSMAP
//
////////////////////////////////////////////////////////////////////////
const static NAMEMAP g_rgRowStatusMap[] =
{	
    VALUE_CHAR(DBROWSTATUS_S_OK	),
	VALUE_CHAR(DBROWSTATUS_S_MULTIPLECHANGES	),
	VALUE_CHAR(DBROWSTATUS_S_PENDINGCHANGES	),
	VALUE_CHAR(DBROWSTATUS_E_CANCELED	),
	VALUE_CHAR(DBROWSTATUS_E_CANTRELEASE	),
	VALUE_CHAR(DBROWSTATUS_E_CONCURRENCYVIOLATION	),
	VALUE_CHAR(DBROWSTATUS_E_DELETED	),
	VALUE_CHAR(DBROWSTATUS_E_PENDINGINSERT	),
	VALUE_CHAR(DBROWSTATUS_E_NEWLYINSERTED	),
	VALUE_CHAR(DBROWSTATUS_E_INTEGRITYVIOLATION	),
	VALUE_CHAR(DBROWSTATUS_E_INVALID	),
	VALUE_CHAR(DBROWSTATUS_E_MAXPENDCHANGESEXCEEDED	),
	VALUE_CHAR(DBROWSTATUS_E_OBJECTOPEN	),
	VALUE_CHAR(DBROWSTATUS_E_OUTOFMEMORY	),
	VALUE_CHAR(DBROWSTATUS_E_PERMISSIONDENIED	),
	VALUE_CHAR(DBROWSTATUS_E_LIMITREACHED	),
	VALUE_CHAR(DBROWSTATUS_E_SCHEMAVIOLATION	),
	VALUE_CHAR(DBROWSTATUS_E_FAIL	),
};

////////////////////////////////////////////////////////////////////////
// HRESULT DisplayRowErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayRowErrors(HWND hWnd, ULONG cRows, HROW* rghRows, DBROWSTATUS* rgRowStatus)
{
	//Display the badstatus for row operations.
	HRESULT hr = S_OK;
	INT iSelect = 0;

	for(ULONG i=0; i<cRows; i++)
	{
		ASSERT(rghRows);
		ASSERT(rgRowStatus);
		
		switch(rgRowStatus[i])
		{
			case DBROWSTATUS_S_OK:
				break;

			//Display RowStatus Error to the user...
			default:
			{
				iSelect = wMessageBox(hWnd, MB_TASKMODAL | MB_ICONERROR | MB_OKCANCEL, wsz_ERROR, 
					L"Row Status Errors:\n\n"
					L"rghRow[%d] = 0x%08x\n"
					L"DBROWSTATUS = %d=%S",
					i,
					rghRows[i],
					rgRowStatus[i],
					GetMapName(rgRowStatus[i], NUMELE(g_rgRowStatusMap), g_rgRowStatusMap)
					);

				if(iSelect == IDCANCEL)
					goto CLEANUP;
				break;
			}
		}
	}

CLEANUP:
	return hr;
}


////////////////////////////////////////////////////////////////////////
// STATUSMAP
//
////////////////////////////////////////////////////////////////////////
const static NAMEMAP g_rgBindStatusMap[] =
{	
    VALUE_CHAR(DBBINDSTATUS_OK	),
	VALUE_CHAR(DBBINDSTATUS_BADORDINAL	),
	VALUE_CHAR(DBBINDSTATUS_UNSUPPORTEDCONVERSION	),
	VALUE_CHAR(DBBINDSTATUS_BADBINDINFO	),
	VALUE_CHAR(DBBINDSTATUS_BADSTORAGEFLAGS	),
	VALUE_CHAR(DBBINDSTATUS_NOINTERFACE	),
	VALUE_CHAR(DBBINDSTATUS_MULTIPLESTORAGE	),
};

////////////////////////////////////////////////////////////////////////
// HRESULT DisplayAccessorErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayAccessorErrors(HWND hWnd, ULONG cBindings, DBBINDING* rgBindings, DBBINDSTATUS* rgStatus)
{
	//Display the badstatus for row operations.
	HRESULT hr = S_OK;
	INT iSelect = 0;

	for(ULONG i=0; i<cBindings; i++)
	{
		ASSERT(rgBindings);
		ASSERT(rgStatus);
		
		switch(rgStatus[i])
		{
			case DBBINDSTATUS_OK:
				break;

			//Display BindStatus Error to the user...
			default:
			{
				iSelect = wMessageBox(hWnd, MB_TASKMODAL | MB_ICONERROR | MB_OKCANCEL, wsz_ERROR, 
					L"Accessor BindStatus Errors:\n"
					L"rgBindings[%d]\n\n"
					L"iOrdinal = %d\n"
					L"wType = %s\n"
					L"cbMaxLen = %d\n"
					L"bPrecision = %d\n"
					L"bScale = %d\n\n"
					L"DBBINDSTATUS = %S",
					i,
					rgBindings[i].iOrdinal,
					GetDBTypeName(rgBindings[i].wType),
					rgBindings[i].cbMaxLen,
					rgBindings[i].bPrecision,
					rgBindings[i].bScale,
					GetMapName(rgStatus[i], NUMELE(g_rgBindStatusMap), g_rgBindStatusMap)
					);

				if(iSelect == IDCANCEL)
					goto CLEANUP;
				break;
			}	
		}
	}

CLEANUP:
	return hr;
}

////////////////////////////////////////////////////////////////////////
// HRESULT DisplayPropErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayPropErrors(HWND hWnd, ULONG cPropSets, DBPROPSET* rgPropSets)
{
	//Display a dialog with the affending properties...
	HRESULT hr = S_OK;
	INT iSelect = 0;

	for(ULONG i=0; i<cPropSets; i++)
	{
		for(ULONG j=0; j<rgPropSets[i].cProperties; j++)
		{
			DBPROPSET* pPropSet = &rgPropSets[i];
			DBPROP* pProp = &pPropSet->rgProperties[j];
			if(pProp->dwStatus != DBPROPSTATUS_OK)
			{
				WCHAR wszBuffer[MAX_NAME_LEN+1];
				CHAR szPropSet[MAX_NAME_LEN+1];
				CHAR* pszPropSet = GetPropSetName(pPropSet->guidPropertySet);
				if(pszPropSet == NULL)
				{	
					StringFromGUID2(pPropSet->guidPropertySet, wszBuffer, MAX_NAME_LEN);
					ConvertToMBCS(wszBuffer, szPropSet, MAX_NAME_LEN);
					pszPropSet = szPropSet;
				}

				//Find property Value
				wszBuffer[0] = wEOL;
				VariantToString(&pProp->vValue, wszBuffer, MAX_NAME_LEN, CONV_VARBOOL);

				//Append the Error
				iSelect = wMessageBox
					(
				    hWnd, MB_TASKMODAL | MB_ICONERROR | MB_OKCANCEL, wsz_ERROR, 
					L"Properties in Error:\n"
					L"rgPropSets[%d].rgProperties[%d]\n\n"
					L"guidPropertySet\t= %S\n"
					L"dwPropertyID\t= %S (0x%x)\n"
					L"dwOptions\t\t= %s\n"
					L"vValue.vt\t\t= %S\n"
					L"vValue\t\t= %s\n\n"
					L"dwStatus\t\t= %s",
					i,j,
					pszPropSet,
					GetPropertyName(pProp->dwPropertyID, pPropSet->guidPropertySet),
					pProp->dwPropertyID, 
					pProp->dwOptions == DBPROPOPTIONS_REQUIRED ? L"DBPROPOPTIONS_REQUIRED" : L"DBPROPOPTIONS_OPTIONAL",
					GetVariantTypeName(V_VT(&pProp->vValue)),
					wszBuffer,
					GetMapName(pProp->dwStatus, NUMELE(g_rgPropStatusMap), g_rgPropStatusMap)
					);

				if(iSelect == IDCANCEL)
					goto CLEANUP;
			}
		}
	}

CLEANUP:
	return hr;
}


////////////////////////////////////////////////////////////////////////
// HRESULT DisplayPropErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayPropErrors(HWND hWnd, SOURCE ePropSource, IUnknown* pIUnknown)
{
	ASSERT(pIUnknown);

	//GetProperties with DBPROPSET_PROPERTIESINERROR.
	HRESULT hr = S_OK;
	ULONG cPropSets = 0;
	DBPROPSET* rgPropSets = NULL;
	IDBProperties* pIDBProperties = NULL;
	ICommandProperties* pICommandProperties = NULL;

	//Setup input DBPROPSET_PROPERTIESINERROR
	const ULONG cPropertyIDSets = 1;
	DBPROPIDSET rgPropertyIDSets[cPropertyIDSets];
	rgPropertyIDSets[0].guidPropertySet = DBPROPSET_PROPERTIESINERROR;
	rgPropertyIDSets[0].cPropertyIDs = 0;
	rgPropertyIDSets[0].rgPropertyIDs = NULL;

	//ICommand::GetProperties 
	switch(ePropSource)
	{
		case DATASOURCE:
		{	
			XTESTC(hWnd, hr = pIUnknown->QueryInterface(IID_IDBProperties, (void**)&pIDBProperties));
			XTESTC(hWnd, hr = pIDBProperties->GetProperties(cPropertyIDSets, rgPropertyIDSets, &cPropSets, &rgPropSets));
			break;
		}

		case COMMAND:
		{	
			XTESTC(hWnd, hr = pIUnknown->QueryInterface(IID_ICommandProperties, (void**)&pICommandProperties));
			XTESTC(hWnd, hr = pICommandProperties->GetProperties(cPropertyIDSets, rgPropertyIDSets, &cPropSets, &rgPropSets));
			break;
		}

		default:
			ASSERT(!"Unhandled Type!");
			break;
	};

	//Now delegate to display all properties in error
	XTESTC(hWnd, hr = DisplayPropErrors(hWnd, cPropSets, rgPropSets));

CLEANUP:
	FreeProperties(&cPropSets, &rgPropSets);
	SAFE_RELEASE(pICommandProperties);
	SAFE_RELEASE(pIDBProperties);
	return hr;
}


////////////////////////////////////////////////////////////////////////
// HRESULT DisplayRefCountErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayRefCountErrors(HWND hWnd, CHAR* pszName, ULONG ulActRefCount, ULONG ulExpRefCount)
{
	ASSERT(pszName);

	//Display RefCount difference...
	if(ulActRefCount != ulExpRefCount && GetErrorPosting(EP_REFCOUNT_FAILURE))
	{
		wMessageBox
			(
			hWnd, 
			MB_TASKMODAL | MB_ICONERROR | MB_OK, 
			wsz_ERROR, 
			L"%S\n"
			L"RefCount = %d, Expected = %d",
			pszName,
			ulActRefCount,
			ulExpRefCount
			);
	}
		
	return S_OK;
}


////////////////////////////////////////////////////////////////////////
// HRESULT DisplayAllErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayAllErrors(HWND hWnd, HRESULT hrActual, WCHAR* pwszFile, ULONG ulLine)
{
	//Delegate
	if(FAILED(hrActual) || GetErrorPosting(EP_ERRORINFO_ALWAYS) || GetErrorPosting(EP_HRESULT_ALWAYS))
		DisplayAllErrors(hWnd, hrActual, hrActual, pwszFile, ulLine);

	return hrActual;
}

////////////////////////////////////////////////////////////////////////
// HRESULT DisplayAllErrors
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayAllErrors(HWND hWnd, HRESULT hrActual, HRESULT hrExpected, WCHAR* pwszFile, ULONG ulLine)
{
	//By Default we only worry about ErrorInfo if(FAILED(hr))
	//But we may want to worry about it at other times as well?
	if((FAILED(hrActual) || (hrActual!=hrExpected) || GetErrorPosting(EP_ERRORINFO_ALWAYS)) &&
		!GetErrorPosting(EP_ERRORINFO_NEVER))
	{
		if(DisplayAllErrorInfo(hWnd, pwszFile, ulLine)==S_OK)
		{
			//We had ErrorInfo, no need to display error info
			//Unless the user has something other than NOERRORINFO selected
			if(GetErrorPosting(EP_HRESULT_NOERRORINFO))
				goto CLEANUP;
		}
	}
	
	//If not available, display MSG Box with info
	if((FAILED(hrActual) || (hrActual!=hrExpected) || (hrActual!=S_OK && GetErrorPosting(EP_HRESULT_ALWAYS))) &&
		!GetErrorPosting(EP_HRESULT_NEVER))
	{
		//Display the HRESULT
		DisplayHRESULT(hWnd, hrActual, pwszFile, ulLine);
	}

CLEANUP:
	if(hrActual!=hrExpected && SUCCEEDED(hrActual))
		return E_FAIL;
	
	return hrActual;
}


////////////////////////////////////////////////////////////////////////
// HRESULT DisplayHRESULT
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayHRESULT(HWND hWnd, HRESULT hrActual, WCHAR* pwszFile, ULONG ulLine)
{
	//display the Error
	wMessageBox(hWnd, MB_TASKMODAL | MB_ICONERROR | MB_OK, wsz_ERROR, 
		L"Interface: %s\nResult: 0x%08x = %s\n\nFile: %s\nLine: %d", L"Unknown", hrActual, GetErrorName(hrActual), pwszFile, ulLine);

	return hrActual;
}


////////////////////////////////////////////////////////////////////////
// HRESULT DisplayAllErrorInfo
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayAllErrorInfo(HWND hWnd, WCHAR* pwszFile, ULONG ulLine)
{
	ULONG cRecords = 0;
	IErrorRecords* pIErrorRecords = NULL;
	HRESULT hr = S_OK;

	//Try to display Extened ErrorInfo
	if((hr = GetErrorRecords(hWnd, &cRecords, &pIErrorRecords))==S_OK && cRecords) 
	{
		DisplayErrorRecords(hWnd, cRecords, pIErrorRecords, pwszFile, ulLine);
		SAFE_RELEASE(pIErrorRecords);
	}

	return hr;
}


////////////////////////////////////////////////////////////////////////
// HRESULT GetErrorRecords
//
// Get the error message generated by an OLE DB object
/////////////////////////////////////////////////////////////////////////////
HRESULT GetErrorRecords(HWND hWnd, ULONG* pcRecords, IErrorRecords** ppIErrorRecords)
{
	ASSERT(pcRecords && ppIErrorRecords);
	HRESULT hr;

	//NULL output params
	*pcRecords = 0;
	*ppIErrorRecords = NULL;
	
	ISupportErrorInfo* pISupportErrorInfo = NULL;
	IErrorInfo* pIErrorInfo = NULL;

	//See if this interface supports ErrorInfo
	//If not there is no reason to display any error
	if((hr = GetErrorInfo(0, &pIErrorInfo))==S_OK && pIErrorInfo)
	{
		//IErrorRecords may not be supported on the existing error object.
		//Some other things could have posted an error object (VB) for example...
		TESTC(hr = pIErrorInfo->QueryInterface(IID_IErrorRecords, (void**)ppIErrorRecords));
		XTESTC(hWnd, hr = (*ppIErrorRecords)->GetRecordCount(pcRecords));
	}
		
CLEANUP:
	SAFE_RELEASE(pISupportErrorInfo);
	SAFE_RELEASE(pIErrorInfo);
	return hr;
}


////////////////////////////////////////////////////////////////////////
// HRESULT GetSqlErrorInfo
//
// Get the error message generated by an OLE DB object
/////////////////////////////////////////////////////////////////////////////
HRESULT GetSqlErrorInfo(ULONG iRecord, IErrorRecords* pIErrorRecords, BSTR* pBstr, LONG* plNativeError)
{
	ASSERT(pBstr);
	HRESULT hr = S_OK;

	ISQLErrorInfo* pISQLErrorInfo = NULL;
	LONG lNativeError = 0;

	//Get the Error Records
	if(pIErrorRecords)
	{
		//If there is ErrorInfo, GetSQLInfo for the desired record
		//ISQLErrorInfo is not mandatory
		TESTC(hr = pIErrorRecords->GetCustomErrorObject(iRecord, IID_ISQLErrorInfo, (IUnknown**)&pISQLErrorInfo));
		
		//If there was a CustomErrorObject
		if(pISQLErrorInfo)
			hr = pISQLErrorInfo->GetSQLInfo(pBstr, &lNativeError);
	}

CLEANUP:
	if(plNativeError)
		*plNativeError = lNativeError;
	SAFE_RELEASE(pISQLErrorInfo);
	return hr;
}


////////////////////////////////////////////////////////////////////////
// HRESULT DisplayErrorRecords
//
/////////////////////////////////////////////////////////////////////////////
HRESULT DisplayErrorRecords(HWND hWnd, ULONG cRecords, IErrorRecords* pIErrorRecords, WCHAR* pwszFile, ULONG ulLine)
{
	HRESULT hr = S_OK;

	IErrorInfo* pIErrorInfo = NULL;
	BSTR bstrDescription = NULL;
	BSTR bstrSource = NULL;
	BSTR bstrSQLInfo = NULL;
	INT  iSelect = 0;

	static LCID lcid = GetSystemDefaultLCID(); 

	//Get the Error Records
	if(cRecords && pIErrorRecords)
	{
		LONG lNativeError = 0;
		ERRORINFO ErrorInfo;

		//Loop through the records
		for(ULONG i=0; i<cRecords; i++)
		{
			//GetErrorInfo
			XTESTC(hWnd, hr = pIErrorRecords->GetErrorInfo(i,lcid,&pIErrorInfo));
				
			//Get the Description
			XTESTC(hWnd, hr = pIErrorInfo->GetDescription(&bstrDescription));
				
			//Get the Source - this will be the window title...
			XTESTC(hWnd, hr = pIErrorInfo->GetSource(&bstrSource));

			//Get the Basic ErrorInfo
			XTESTC(hWnd, hr = pIErrorRecords->GetBasicErrorInfo(i,&ErrorInfo));
			
			//Get the SQL Info
			GetSqlErrorInfo(i, pIErrorRecords, &bstrSQLInfo, &lNativeError);

			//Display the Error
			if(bstrSQLInfo)
				iSelect = wMessageBox(hWnd, MB_TASKMODAL | MB_ICONERROR | MB_OKCANCEL, bstrSource ? bstrSource : wsz_ERRORINFO, L"Interface: %S\nResult: 0x%08x = %s\n\nISQLErrorInfo: [%s][0x%08x]\n\nSource: \"%s\"\nIErrorInfo: [0x%08x] \"%s\"\n\nFile: %s\nLine: %d", GetInterfaceName(ErrorInfo.iid), ErrorInfo.hrError, GetErrorName(ErrorInfo.hrError), bstrSQLInfo, lNativeError, bstrSource, ErrorInfo.dwMinor, bstrDescription, pwszFile, ulLine);
			else
				iSelect = wMessageBox(hWnd, MB_TASKMODAL | MB_ICONERROR | MB_OKCANCEL, bstrSource ? bstrSource : wsz_ERRORINFO, L"Interface: %S\nResult: 0x%08x = %s\n\nSource: \"%s\"\nIErrorInfo: [0x%08x] \"%s\"\n\nFile: %s\nLine: %d", GetInterfaceName(ErrorInfo.iid), ErrorInfo.hrError, GetErrorName(ErrorInfo.hrError), bstrSource, ErrorInfo.dwMinor, bstrDescription, pwszFile, ulLine);

			SAFE_RELEASE(pIErrorInfo);
			SAFE_SYSFREE(bstrDescription);
			SAFE_SYSFREE(bstrSource);
			SAFE_SYSFREE(bstrSQLInfo);

			if(iSelect == IDCANCEL)
				goto CLEANUP;
		}
	}
	

CLEANUP:
	SAFE_RELEASE(pIErrorInfo);
	SAFE_SYSFREE(bstrDescription);
	SAFE_SYSFREE(bstrSource);
	SAFE_SYSFREE(bstrSQLInfo);
	return hr;
}
